package com.wissamfawaz;

import java.util.Scanner;

public class Main {
    public static void main(String[] args) {
        String winner = null;
        Scanner scan = new Scanner(System.in);
        String[] players = { "Mohamad", "Steven", "Mouaz" };
        int k;

        System.out.println("Enter k: ");
        k = scan.nextInt();

        try {
            winner = solve(players, k);
        } catch (QueueException e) {

        }

        if (winner == null) {
            System.out.println("Could not solve the problem.");
        } else {
            System.out.println("Winner: " + winner);
        }

        scan.close();
    }

    private static String solve(String[] players, int k) throws QueueException {
        Queue queue = new ArrayBasedQueue(players.length);
        String winner = null;

        for (String player : players) {
            queue.enqueue(player);
        }

        while (queue.size() > 1) {
            System.out.println("Active players: " + queue);
            for (int i = 1; i <= k; i++) {
                queue.enqueue(queue.dequeue());
            }
            System.out.println(queue.dequeue() + " is out.");
        }

        if (queue.size() == 1) {
            winner = queue.dequeue().toString();
        }

        return winner;
    }

}
